<?php


header('Content-Type: application/json');

// Clave AES secreta en el servidor
$secret_key = "3e1g9x52z15b2u54";

// Cargar la clave privada
$private_key_path = '/public_html/panel_api/private_key.pem'; // Cambia esto después
$private_key = openssl_pkey_get_private(file_get_contents($private_key_path));
if (!$private_key) {
    http_response_code(500);
    echo json_encode(["error" => "Server error"]);
    exit;
}

// Obtener el nonce encriptado desde la solicitud
$encrypted_nonce = isset($_POST['nonce']) ? $_POST['nonce'] : null;

if (!$encrypted_nonce) {
    http_response_code(400);
    echo json_encode(["error" => "TOKEN INVALIDO"]);
    exit;
}

// Desencriptar el nonce con la clave privada
$nonce = null;
if (!openssl_private_decrypt(base64_decode($encrypted_nonce), $nonce, $private_key)) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid nonce"]);
    exit;
}

// Verificar que el nonce sea válido (un timestamp reciente)
$nonce_time = (int)$nonce;
$current_time = time();
if (abs($current_time - $nonce_time) > 300) { // 5 minutos de tolerancia
    http_response_code(400);
    echo json_encode(["error" => "Nonce expired"]);
    exit;
}

// Generar una clave temporal basada en el nonce
$temp_key = hash('sha256', $nonce, true); // 32 bytes, se trunca después

// Encriptar la clave AES con la clave temporal
$cipher = "AES-128-ECB";
$encrypted_key = openssl_encrypt($secret_key, $cipher, substr($temp_key, 0, 16), OPENSSL_RAW_DATA);
if ($encrypted_key === false) {
    http_response_code(500);
    echo json_encode(["error" => "Encryption failed"]);
    exit;
}

// Devolver la clave AES encriptada
echo json_encode(["encrypted_key" => base64_encode($encrypted_key)]);
?>