<?php
// Verifica si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtiene el nuevo token del formulario
    $nuevo_token = $_POST['token'];

    // Crea un array con el nuevo token
    $data = [
        'token' => $nuevo_token
    ];

    // Guarda el nuevo token en el archivo token.json
    file_put_contents('token.json', json_encode($data, JSON_PRETTY_PRINT));

    // Mensaje de éxito
    $mensaje = "Token actualizado exitosamente.";
}

// Lee el contenido actual de token.json
$contenido_json = file_get_contents('token.json');
$contenido = json_decode($contenido_json, true);
$token_actual = $contenido['token'] ?? '';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Actualizar Token</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        input[type="submit"] {
            background-color: #4CAF50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background-color: #45a049;
        }
        .mensaje {
            color: green;
            margin-top: 10px;
        }
    </style>
</head>
<body>

<h1>Actualizar Token</h1>
<form method="post">
    <label for="token">Token Actual:</label>
    <input type="text" id="token" name="token" value="<?php echo htmlspecialchars(str_replace('Bearer ', '', $token_actual)); ?>" required>
    <input type="submit" value="Actualizar Token">
</form>

<?php if (isset($mensaje)) : ?>
    <div class="mensaje"><?php echo $mensaje; ?></div>
<?php endif; ?>

</body>
</html>