<?php
session_start();

// Verificar si el usuario ha iniciado sesión
if (!isset($_SESSION['user_email'])) {
    header("Location: index.php");
    exit();
}

// Función para generar email aleatorio y verificar que no exista en la DB
function generarEmailUnico($conn) {
    $letras = 'abcdefghijklmnopqrstuvwxyz';
    $intentos = 0;
    $maxIntentos = 100; // Límite de intentos para evitar bucles infinitos
    
    do {
        $usuario = '';
        for ($i = 0; $i < 8; $i++) {
            $usuario .= $letras[rand(0, strlen($letras) - 1)];
        }
        
        $email = $usuario . '@yae.tv';
        
        // Verificar si el email ya existe en la base de datos
        $stmt = $conn->prepare("SELECT COUNT(*) FROM users WHERE email = :email");
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        
        $intentos++;
        
        // Si encontramos un email único o alcanzamos el límite de intentos, salimos del bucle
        if ($count == 0 || $intentos >= $maxIntentos) {
            break;
        }
    } while (true);
    
    return $email;
}

// Función para generar contraseña numérica aleatoria
function generarPassword($longitud = 6) {
    $numeros = '0123456789';
    $password = '';
    for ($i = 0; $i < $longitud; $i++) {
        $password .= $numeros[rand(0, strlen($numeros) - 1)];
    }
    return $password;
}

// Establecer conexión a la base de datos
try {
    include 'db.php';
    $conn = $pdo;

    // Variable para almacenar un email generado para JavaScript
    $emailGenerado = generarEmailUnico($conn);
    $passwordGenerada = generarPassword();
} catch(PDOException $e) {
    $emailGenerado = "error@yae.tv";
    $passwordGenerada = "123456";
    $errorConexion = $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar Usuario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles/add_reseller.css">
    <script>
        function copiarDatosVisibles() {
            // Obtiene el elemento que contiene los datos
            const datosUsuario = document.getElementById('datosUsuario');
            
            // Crear un elemento temporal para la selección
            const elementoTemporal = document.createElement("textarea");
            elementoTemporal.value = datosUsuario.innerText;
            
            // Hacer que el elemento sea invisible pero esté en el DOM
            elementoTemporal.setAttribute('readonly', '');
            elementoTemporal.style.position = 'absolute';
            elementoTemporal.style.left = '-9999px';
            
            document.body.appendChild(elementoTemporal);
            
            // En dispositivos móviles, ajustamos la selección manualmente
            elementoTemporal.select();
            elementoTemporal.setSelectionRange(0, 99999); // Para dispositivos móviles
            
            try {
                document.execCommand('copy');
                alert('Datos copiados al portapapeles');
            } catch (err) {
                alert('No se pudo copiar automáticamente. Por favor, selecciona y copia manualmente.');
            }
            
            document.body.removeChild(elementoTemporal);
        }
        
        // Función para solicitar un nuevo email mediante AJAX
        async function solicitarNuevoEmail() {
            try {
                const response = await fetch('generar_email.php');
                if (!response.ok) {
                    throw new Error('Error en la solicitud');
                }
                const data = await response.json();
                if (data.email) {
                    document.getElementById('email').value = data.email;
                }
            } catch (error) {
                console.error('Error al generar email:', error);
            }
        }
    </script>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8 col-sm-10">
                <div class="form-container">
                    <h2 class="form-title">Agregar Nuevo Usuario</h2>
                    <?php 
                    if (isset($errorConexion)) {
                        echo '<div class="alert alert-danger" role="alert">Error de conexión: ' . $errorConexion . '</div>';
                    }
                    
                    $pause = 0; // Valor predeterminado

                    try {
                        // Consultar el valor de pause y créditos del reseller
                        $stmt = $conn->prepare("SELECT pause, creditos FROM resellers WHERE email = :email");
                        $stmt->bindParam(':email', $_SESSION['user_email']);
                        $stmt->execute();
                        $result = $stmt->fetch(PDO::FETCH_ASSOC);

                        if ($result) {
                            $pause = $result['pause'];
                        }
                    } catch(PDOException $e) {
                        echo '<div class="alert alert-danger" role="alert">Error: ' . $e->getMessage() . '</div>';
                    }

                    // Comprobación de la pausa
                    if ($pause == 1) {
                        echo '<div class="alert alert-warning" role="alert">CUENTA PAUSADA</div>';
                    } else {
                        // Proceso de agregar un nuevo usuario
                        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                            $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
                            $phone = htmlspecialchars($_POST['phone'], ENT_QUOTES, 'UTF-8'); 
                            $password = $_POST['password']; 
                            $meses = intval($_POST['meses']);
                            
                            // Si email está vacío, generar uno automáticamente
                            if (empty($email)) {
                                $email = generarEmailUnico($conn);
                            }
                            
                            // Si password está vacío, generar uno automáticamente
                            if (empty($password)) {
                                $password = generarPassword();
                            }

                            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                                echo '<div class="alert alert-danger" role="alert">Error: Email no válido.</div>';
                            } elseif ($meses < 1 || $meses > 12) {
                                echo '<div class="alert alert-danger" role="alert">Error: Número de meses no válido.</div>';
                            } elseif (!ctype_digit($password) && !empty($_POST['password'])) {
                                echo '<div class="alert alert-danger" role="alert">Error: La contraseña debe contener solo números.</div>';
                            } else {
                                // Verificar si el usuario que intenta agregar tiene suficientes créditos
                                if ($result['creditos'] >= $meses) {
                                    // Verificar si el email ya existe (verificación final)
                                    $stmt = $conn->prepare("SELECT COUNT(*) FROM users WHERE email = :email");
                                    $stmt->bindParam(':email', $email);
                                    $stmt->execute();
                                    $count = $stmt->fetchColumn();
                                    
                                    if ($count > 0) {
                                        echo '<div class="alert alert-danger" role="alert">Error: El email ya está registrado en el sistema. Por favor, intente con otro email o deje el campo vacío para generar uno automáticamente.</div>';
                                    } else {
                                        $now = new DateTime("now", new DateTimeZone("America/Argentina/Buenos_Aires"));
                                        $vencimiento = $now->modify("+$meses months")->format('Y-m-d H:i:s');

                                        
                                        // Insertar el nuevo usuario
                                        $stmt = $conn->prepare("INSERT INTO users (email, phone, password, vencimiento, idv, demo) 
                                                                VALUES (:email, :phone, :password, :vencimiento, :idv, 'false')");
                                        $stmt->bindParam(':email', $email);
                                        $stmt->bindParam(':phone', $phone);
                                        $stmt->bindParam(':password', $password); 
                                        $stmt->bindParam(':vencimiento', $vencimiento);
                                        $stmt->bindParam(':idv', $_SESSION['user_email']);
                                        $stmt->execute();

                                        // Actualizar créditos
                                        $stmt = $conn->prepare("UPDATE resellers SET creditos = creditos - :meses WHERE email = :email");
                                        $stmt->bindParam(':meses', $meses);
                                        $stmt->bindParam(':email', $_SESSION['user_email']);
                                        $stmt->execute();

                                        echo '<div class="alert alert-success" role="alert">
                                            <strong>Usuario creado con éxito</strong>
                                        </div>
                                        <div class="user-data-container p-3 border rounded bg-light mb-3">
                                            <h6>Datos del usuario:</h6>
                                            <div id="datosUsuario">
                                                <p><strong>Email:</strong> ' . $email . '</p>
                                                <p><strong>Contraseña:</strong> ' . $password . '</p>
                                                <p><strong>Vencimiento:</strong> ' . $vencimiento . '</p>
                                                <p><strong>CÓDIGO PARA DOWNLOADER:</strong> 1014739</p>
                                                <p><strong>URL DE DESCARGA DIRECTA:</strong> aftv.news/1014739</p>
                                                <p><strong>URL DE DESCARGA DIRECTA 2:</strong> yaetv.com/yaetv.apk</p>
                                                <p><strong>VERSION SIMPLE LIGERA:</strong> EXCLUSICO PARA TV Y DISPOSITIVOS CHINOS</p>
                                                <p><strong>CÓDIGO PARA DOWNLOADER APP LIGERA:</strong> 5628296</p>
                                                <p><strong>URL DE DESCARGA DIRECTA APP LIGERA:</strong> aftv.news/5628296</p>
                                                
                                            </div>
                                            <button id="btnCopiar" class="btn btn-primary mt-2" onclick="copiarDatosVisibles()">
                                                <i class="fas fa-copy"></i> Copiar todos los datos
                                            </button>
                                        </div>';
                                    }
                                } else {
                                    echo '<div class="alert alert-danger" role="alert">Error: No tienes suficientes créditos para agregar un nuevo usuario por ' . $meses . ' meses.</div>';
                                }
                            }
                        } else {
                            // Mostrar el formulario si no hay errores
                            ?>
                            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email:</label>
                                    <div class="input-group">
                                        <input type="email" class="form-control" id="email" name="email" placeholder="Dejar vacío para generar automáticamente">
                                        <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('email').value='<?php echo $emailGenerado; ?>'">
                                            Generar
                                        </button>
                                    </div>
                                    <small class="form-text text-muted">Si se deja vacío, se generará un email único con formato user@yae.tv</small>
                                </div>
                                <div class="mb-3">
                                    <label for="password" class="form-label">Contraseña:</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="password" name="password" placeholder="Dejar vacío para generar automáticamente">
                                        <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('password').value='<?php echo $passwordGenerada; ?>'">
                                            Generar
                                        </button>
                                    </div>
                                    <small class="form-text text-muted">Solo números. Si se deja vacío, se generará automáticamente.</small>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="phone" class="form-label">Teléfono:</label>
                                        <input type="text" class="form-control" id="phone" name="phone" required placeholder="123456789">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="meses" class="form-label">Duración (meses):</label>
                                        <select id="meses" name="meses" class="form-select" required>
                                            <?php for ($i = 1; $i <= 12; $i++) : ?>
                                                <option value="<?php echo $i; ?>"><?php echo $i; ?> <?php echo $i == 1 ? 'mes' : 'meses'; ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3 text-center">
                                    <button type="button" class="btn btn-info" onclick="
                                        document.getElementById('email').value='<?php echo $emailGenerado; ?>';
                                        document.getElementById('password').value='<?php echo $passwordGenerada; ?>';
                                    ">Generar Todo</button>
                                    <button type="submit" class="btn btn-success btn-lg">Agregar Usuario</button>
                                </div>
                            </form>
                            <?php
                        }
                    }
                    ?>
                    <div class="mt-3 text-center">
                        <a href="opciones.php" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left"></i> Volver al Panel de Control
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>