<?php
session_start();
include 'db.php';

// Solo permitir acceso al admin (puedes ajustar esta lógica según tu sistema)
if (!isset($_SESSION['user_email']) || $_SESSION['user_email'] !== 'carlosrf2007@gmail.com') {
    header("Location: index.php");
    exit();
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titulo = trim($_POST['titulo']);
    $cuerpo = trim($_POST['cuerpo']);
    $destinatario = $_POST['destinatario'];

    if ($titulo && $cuerpo && in_array($destinatario, ['all', 'reseller', 'user'])) {
        $stmt = $pdo->prepare("INSERT INTO mensajes (titulo, cuerpo, destinatario) VALUES (?, ?, ?)");
        $stmt->execute([$titulo, $cuerpo, $destinatario]);
        $msg = '<div class="alert alert-success">Mensaje enviado correctamente.</div>';
    } else {
        $msg = '<div class="alert alert-danger">Completa todos los campos.</div>';
    }
}
$is_ajax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']);
?>
<?php if (!$is_ajax): ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Enviar Mensaje Global</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Enviar Mensaje Global</h2>
<?php endif; ?>
    <?php echo $msg; ?>
    <form method="post" class="mt-4">
        <div class="mb-3">
            <label class="form-label">Título</label>
            <input type="text" name="titulo" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Mensaje</label>
            <textarea name="cuerpo" class="form-control" rows="5" required></textarea>
        </div>
        <div class="mb-3">
            <label class="form-label">Destinatario</label>
            <select name="destinatario" class="form-select" required>
                <option value="reseller">Solo Revendedores</option>
            </select>
        </div>
        <button type="submit" class="btn btn-success">Enviar Mensaje</button>
    </form>
<?php if (!$is_ajax): ?>
</div>
</body>
</html>
<?php endif; ?>