<?php
session_start();
include 'db.php';

if (!isset($_SESSION['user_email'])) {
    header("Location: index.php");
    exit();
}

$user_email = $_SESSION['user_email'];
// Determinar tipo de usuario (ajusta según tu sistema)
$is_reseller = isset($_SESSION['user_id']);

// Marcar como leído
if (isset($_GET['leido']) && is_numeric($_GET['leido'])) {
    $msg_id = intval($_GET['leido']);
    $stmt = $pdo->prepare("SELECT leido_por FROM mensajes WHERE id = ?");
    $stmt->execute([$msg_id]);
    $row = $stmt->fetch();
    $leido_por = $row && $row['leido_por'] ? explode(',', $row['leido_por']) : [];
    if (!in_array($user_email, $leido_por)) {
        $leido_por[] = $user_email;
        $stmt = $pdo->prepare("UPDATE mensajes SET leido_por = ? WHERE id = ?");
        $stmt->execute([implode(',', $leido_por), $msg_id]);
    }
    // Si es AJAX, solo recarga el contenido
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH'])) {
        exit('OK');
    }
    header("Location: bandeja_entrada.php");
    exit();
}

// Obtener mensajes para este usuario
$where = "destinatario = 'all'";
if ($is_reseller) {
    $where .= " OR destinatario = 'reseller'";
} else {
    $where .= " OR destinatario = 'user'";
}
$stmt = $pdo->query("SELECT * FROM mensajes WHERE $where ORDER BY fecha DESC");
$mensajes = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<?php
$is_ajax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']);
?>
<?php if (!$is_ajax): ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bandeja de Entrada</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Bandeja de Entrada</h2>
<?php endif; ?>
    <?php if (empty($mensajes)): ?>
        <div class="alert alert-info mt-4">No tienes mensajes.</div>
    <?php else: ?>
        <div class="list-group mt-4">
            <?php foreach ($mensajes as $msg):
                $leido = $msg['leido_por'] && in_array($user_email, explode(',', $msg['leido_por']));
            ?>
            <div class="list-group-item<?php if (!$leido) echo ' list-group-item-warning'; ?>">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <strong><?php echo htmlspecialchars($msg['titulo']); ?></strong>
                        <span class="text-muted small ms-2"><?php echo date('d/m/Y H:i', strtotime($msg['fecha'])); ?></span>
                    </div>
                    <?php if (!$leido): ?>
                        <a href="?leido=<?php echo $msg['id']; ?>" class="btn btn-sm btn-success">Marcar como leído</a>
                    <?php endif; ?>
                </div>
                <div class="mt-2"><?php echo nl2br(htmlspecialchars($msg['cuerpo'])); ?></div>
            </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
<?php if (!$is_ajax): ?>
    <div class="mt-4">
        <a href="opciones.php" class="btn btn-secondary">Volver al Panel</a>
    </div>
</div>
</body>
</html>
<?php endif; ?>