<?php
// Conexión centralizada
include 'db.php';

try {
    // $pdo ya está disponible desde db.php

    // Obtener email y password de la URL
    $email = $_GET['email'] ?? '';
    $password = $_GET['password'] ?? '';

    // Preparar la consulta
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email AND password = :password");
    $stmt->execute(['email' => $email, 'password' => $password]);
    $user = $stmt->fetch();

    if ($user) {
        // Verificar si la cuenta no está vencida
        $today = new DateTime();
        $vencimiento = new DateTime($user['vencimiento']);

        if ($vencimiento >= $today) {
            // Cuenta válida, obtener y mostrar el contenido de la URL
            $url = "https://stream.mcdstore.store/jellyfin/playlist.m3u";
            $response = file_get_contents($url);
            
            if ($response === false) {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to fetch the playlist'
                ]);
            } else {
                // Mostrar el contenido de la URL directamente
                header('Content-Type: text/plain');
                echo $response;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Account expired'
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid email or password'
        ]);
    }
} catch (\PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (\Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'General error: ' . $e->getMessage()
    ]);
}