<?php
session_start();

// Conexión centralizada
include 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

try {
    // Obtener los créditos actualizados del usuario logueado
    $stmt = $pdo->prepare("SELECT creditos FROM resellers WHERE id = :user_id");
    $stmt->execute(['user_id' => $_SESSION['user_id']]);
    $result = $stmt->fetch();

    if ($result) {
        $_SESSION['user_credits'] = $result['creditos'];
    } else {
        echo "Error: No se pudo obtener los créditos actualizados.";
    }

    // Estadísticas adicionales

    // Total de usuarios creados por el reseller
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE idv = :email");
    $stmt->execute(['email' => $_SESSION['user_email']]);
    $total_usuarios = $stmt->fetchColumn();

    // Total de revendedores creados por el reseller
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM resellers WHERE idv = :email");
    $stmt->execute(['email' => $_SESSION['user_email']]);
    $total_resellers = $stmt->fetchColumn();

    // Usuarios vencidos hasta ahora (no solo días anteriores)
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE idv = :email AND vencimiento < NOW()");
    $stmt->execute(['email' => $_SESSION['user_email']]);
    $total_vencidos = $stmt->fetchColumn();

    // Usuarios por vencer en 7 días
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE idv = :email AND vencimiento >= NOW() AND vencimiento <= DATE_ADD(NOW(), INTERVAL 7 DAY)");
    $stmt->execute(['email' => $_SESSION['user_email']]);
    $total_por_vencer = $stmt->fetchColumn();

} catch (\PDOException $e) {
    echo "Error de base de datos: " . $e->getMessage();
} catch (\Exception $e) {
    echo "Error general: " . $e->getMessage();
}
?>
