<?php
// /canales/disney/index.php (Deploy to this location)

error_reporting(E_ALL);
ini_set('display_errors', 1); // Enable errors for debugging

// --- CONFIGURACIÓN CORS ---
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
if (!empty($origin)) {
    header("Access-Control-Allow-Origin: $origin");
}
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// --- SESIÓN ---
$domain = $_SERVER['HTTP_HOST'] ?? 'localhost';
$cookieParams = [
    'lifetime' => 3600,
    'path' => '/',
    'secure' => true,
    'httponly' => true,
    'samesite' => 'None'
];

if ($domain !== 'localhost' && filter_var($domain, FILTER_VALIDATE_IP) === false) {
    $cookieParams['domain'] = $domain;
}

session_set_cookie_params($cookieParams);
session_start();

// --- ZONA HORARIA ---
date_default_timezone_set('America/Argentina/Mendoza');

function sendJsonError($message, $code = 401)
{
    http_response_code($code);
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode(['error' => $message]);
    exit;
}

// --- DB ---
require_once __DIR__ . '/../../con/db_config.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true) ?? $_POST;

$usuario = $data['usuario'] ?? '';
$contrasena = $data['contrasena'] ?? '';

$isAuthenticated = false;

try {
    $pdo = getDBConnection();

    // 1. Intento de autenticación directa con usuario/contraseña
    if (!empty($usuario) && !empty($contrasena)) {
        // Sanitizar email
        $usuario = filter_var($usuario, FILTER_SANITIZE_EMAIL);

        $stmt = $pdo->prepare("SELECT id, email, password, vencimiento FROM users WHERE email = :email");
        $stmt->execute(['email' => $usuario]);
        $user = $stmt->fetch();

        if ($user && $contrasena === $user['password']) {
            $isAuthenticated = true;
            $vencimientoStr = $user['vencimiento'];
        } else {
            sendJsonError("Credenciales incorrectas.", 401);
        }
    }
    // 2. Si no hay credenciales, verificar Sesión existente
    elseif (isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare("SELECT vencimiento FROM users WHERE id = :id");
        $stmt->execute(['id' => $_SESSION['user_id']]);
        $userSession = $stmt->fetch();

        if ($userSession) {
            $isAuthenticated = true;
            $vencimientoStr = $userSession['vencimiento'];
        } else {
            // Usuario en sesión ya no existe en DB
            $isAuthenticated = false;
        }
    }

    if (!$isAuthenticated) {
        sendJsonError("Usuario no autenticado.", 401);
    }

    // Verificar vencimiento
    $hoy = new DateTime();
    $vencimiento = new DateTime($vencimientoStr);

    if ($vencimiento < $hoy) {
        sendJsonError("Su cuenta ha expirado.", 403);
    }

} catch (Throwable $e) {
    sendJsonError("Error crítico: " . $e->getMessage(), 500);
}

// Si pasa todas las verificaciones, leemos el token del archivo externo
$tokenFile = __DIR__ . '/token.json';
if (file_exists($tokenFile)) {
    header("Content-Type: application/json; charset=UTF-8");
    readfile($tokenFile);
} else {
    sendJsonError("Token no disponible.", 500);
}
?>