<?php
header('Content-Type: application/json');

// --- CONFIGURACIÓN ---
// Ajustamos la zona horaria para que la hora en Telegram sea la tuya
date_default_timezone_set('America/Argentina/Buenos_Aires');
$TOKEN_FILE = __DIR__ . '/token1.json';

// --- FUNCIÓN DE TELEGRAM ---
function notifyTelegram($mensaje) {
    $token = "8332763033:AAHB9zbuJP2K5qbz2s4o5xMbZd56ReNP3y8";
    $chat_id = "326717436";
    $url = "https://api.telegram.org/bot$token/sendMessage?chat_id=$chat_id&parse_mode=html&text=" . urlencode($mensaje);
    @file_get_contents($url);
}

// Validar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Leer los datos recibidos
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validar que el token exista en el envío
if (!$data || !isset($data['token'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid payload']);
    notifyTelegram("⚠️ <b>Hosting: Error de Recibo</b>\nSe intentó actualizar el token pero el envío llegó vacío o mal formado.");
    exit;
}

// Intentar guardar el archivo token1.json
$result = file_put_contents($TOKEN_FILE, json_encode($data, JSON_PRETTY_PRINT));

if ($result === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to write file']);
    notifyTelegram("🚨 <b>Hosting: Error de Escritura</b>\nEl servidor recibió el token pero no pudo guardarlo en el archivo. Revisa permisos de carpeta.");
    exit;
}

// --- NOTIFICACIÓN DE ÉXITO ---
// Mostramos los primeros 15 caracteres del token para referencia
$token_short = substr($data['token'], 0, 15) . "...";
$timestamp = date('H:i:s d-m-Y');

notifyTelegram("☁️ <b>Hosting Actualizado</b>\n\n" .
               "✅ El token enviado desde el servidor local ha sido recibido y guardado con éxito.\n\n" .
               "<b>Token:</b> <code>$token_short</code>\n" .
               "<b>Hora Local:</b> $timestamp");

// Respuesta al emisor (daemon.py o ReqBin)
echo json_encode([
    'success' => true,
    'message' => 'Token updated',
    'timestamp' => date('Y-m-d H:i:s')
]);