<?php
if (session_status() === PHP_SESSION_NONE) session_start();
$pageTitle = $pageTitle ?? 'Channel Manager';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= h($pageTitle) ?></title>
  <style>
    * { margin:0; padding:0; box-sizing:border-box; }
    body { font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif; line-height:1.6; color:#2d3748; background:#f5f7fa; }
    .container { max-width: 1200px; margin: 0 auto; padding: 1.25rem; }
    header.navbar { background:#1a202c; color:white; }
    .navbar .wrap { max-width:1200px; margin:0 auto; display:flex; align-items:center; justify-content:space-between; padding:.75rem 1rem; }
    .brand { font-weight:700; letter-spacing:.4px; }
    nav a { color:#cbd5e0; text-decoration:none; margin-left:1rem; padding:.4rem .6rem; border-radius:6px; }
    nav a:hover, nav a.active { color:white; background:#2d3748; }
    .card { background:white; border-radius:8px; box-shadow:0 2px 4px rgba(0,0,0,.08); padding:1rem; margin:1rem 0; }
    .btn { padding:.5rem 1rem; border-radius:6px; border:none; cursor:pointer; font-weight:600; }
    .btn-primary { background:#4299e1; color:white; }
    .btn-danger { background:#e53e3e; color:white; }
    .grid { display:grid; grid-template-columns: repeat(auto-fit, minmax(240px,1fr)); gap:1rem; }
    .form-group { display:flex; flex-direction:column; gap:.4rem; }
    label { font-weight:600; color:#4a5568; }
    input, select, textarea { padding:.55rem .7rem; border:1px solid #e2e8f0; border-radius:6px; font-size:1rem; }
    input:focus, select:focus, textarea:focus { outline:none; border-color:#4299e1; box-shadow:0 0 0 3px rgba(66,153,225,.35) }
    table { width:100%; border-collapse:collapse; }
    th, td { padding:.8rem; border-bottom:1px solid #e2e8f0; text-align:left; }
    th { background:#f7fafc; font-weight:700; color:#4a5568; position:sticky; top:0; z-index:1; }
    .badge { display:inline-block; padding:.22rem .5rem; border-radius:999px; background:#ebf8ff; color:#2b6cb0; font-size:.75rem; font-weight:600; }
    .badge-adult { background:#FED7D7; color:#9B2C2C; }
    .badge-success { background:#C6F6D5; color:#22543D; }
    .uri-cell { max-width: 360px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    .switch { position: relative; display: inline-block; width: 46px; height: 24px; }
    .switch input { opacity:0; width:0; height:0; }
    .slider { position:absolute; cursor:pointer; inset:0; background:#cbd5e0; transition:.2s; border-radius:24px; }
    .slider:before { content:""; position:absolute; height:18px; width:18px; left:3px; bottom:3px; background:white; transition:.2s; border-radius:50%; }
    input:checked + .slider { background:#48bb78; }
    input:checked + .slider:before { transform: translateX(22px); }
    .actions { display:flex; gap:.4rem; align-items:center; }
    .flash { padding:.8rem 1rem; border-radius:6px; margin:.5rem 0; }
    .flash.success { background:#d4edda; color:#155724; border:1px solid #c3e6cb; }
    .flash.error { background:#f8d7da; color:#721c24; border:1px solid #f5c6cb; }
    .flash.info { background:#d1ecf1; color:#0c5460; border:1px solid #bee5eb; }
    .header-row { display:flex; gap:.5rem; margin-bottom:.5rem; align-items:center; }
    .header-row input { flex:1; }
    .logo-img { width:40px; height:40px; object-fit:cover; border-radius:4px; }
    tr:hover { background:#f7fafc; }
    .btn:hover { transform:translateY(-1px); box-shadow:0 4px 8px rgba(0,0,0,.15); }
    .btn:active { transform:translateY(0); }
    @media (max-width:640px) {
      .navbar .wrap { flex-direction:column; gap:.5rem; align-items:flex-start; }
      .grid { grid-template-columns:1fr; }
      .actions { flex-wrap:wrap; }
    }
  </style>
</head>
<body>
  <header class="navbar">
    <div class="wrap">
      <div class="brand">Admin Panel</div>
      <nav>
        <a href="../pages/channels.php" class="<?= (basename($_SERVER['PHP_SELF'])==='channels.php')?'active':'' ?>">Canales</a>
        <a href="../pages/categories.php" class="<?= (basename($_SERVER['PHP_SELF'])==='categories.php')?'active':'' ?>">Categorías</a>
        <a href="../logout.php">Salir</a>
      </nav>
    </div>
  </header>
  <main class="container">
