<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: text/html; charset=utf-8');

require_once __DIR__ . '/../includes/config.php'; 
$pdo = pdo();
$pdo->exec("SET NAMES utf8");

$json_url = "https://streamtpcloud.com/eventos.json";
$category_id = 132; 
$logo_defecto = "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTteNujiAoh7t2hIHVtM0S1PCRaGxaleTvOIA&s";
$base_proxy = "http://stream.yaetv.com:8088/live/";

function limpiezaExtrema($texto) {
    $buscar =  ['á','é','í','ó','ú','ñ','Á','É','Í','Ó','Ú','Ñ','ö','ü','Ö','Ü'];
    $poner =   ['a','e','i','o','u','n','A','E','I','O','U','N','o','u','O','U'];
    $texto = str_replace($buscar, $poner, $texto);
    $texto = preg_replace('/[^A-Za-z0-9\s]/', '', $texto);
    return trim(mb_strtoupper($texto, 'UTF-8'));
}

try {
    $json_content = @file_get_contents($json_url);
    $eventos_json = json_decode($json_content, true);
    
    // Si el JSON falla o está vacío, no queremos borrar todo por error, 
    // pero si el JSON es un array vacío [] legítimo, procedemos.
    if (!is_array($eventos_json)) die("Error: JSON no accesible");

    // Asegurar columna de control
    $pdo->exec("ALTER TABLE channels ADD COLUMN IF NOT EXISTS stream_tag VARCHAR(255)");

    $tags_actuales = [];

    foreach ($eventos_json as $evento) {
        parse_str(parse_url($evento['link'], PHP_URL_QUERY), $query);
        $tag = $query['stream'] ?? null;
        
        if (!$tag) continue;
        $tags_actuales[] = $tag; 

        $date = DateTime::createFromFormat('H:i', $evento['time']);
        $hora = ($date) ? $date->modify('+2 hours')->format('H:i') : $evento['time'];

        $titulo = limpiezaExtrema($evento['title']);
        $idioma = !empty($evento['language']) ? " " . limpiezaExtrema($evento['language']) : "";
        $nombre_final = "[$hora] $titulo$idioma";
        $uri_proxy = $base_proxy . $tag . ".m3u8";

        $stmt = $pdo->prepare("SELECT id FROM channels WHERE stream_tag = ? AND category_id = ?");
        $stmt->execute([$tag, $category_id]);
        $existing_id = $stmt->fetchColumn();

        if ($existing_id) {
            $upd = $pdo->prepare("UPDATE channels SET name = ?, uri = ?, logo = ?, webview = 'no', adultos = 0, isMagis = 0 WHERE id = ?");
            $upd->execute([$nombre_final, $uri_proxy, $logo_defecto, $existing_id]);
        } else {
            $ins = $pdo->prepare("INSERT INTO channels (name, uri, category_id, logo, webview, stream_tag, isMagis, adultos, claroandina, headers) 
                                 VALUES (?, ?, ?, ?, 'no', ?, 0, 0, 0, '{}')");
            $ins->execute([$nombre_final, $uri_proxy, $category_id, $logo_defecto, $tag]);
        }
    }

    // --- BLOQUE DE LIMPIEZA REFORZADA ---
    if (!empty($tags_actuales)) {
        // Opción A: Borrar los que NO están en la lista nueva
        $placeholders = implode(',', array_fill(0, count($tags_actuales), '?'));
        $sql_del = "DELETE FROM channels WHERE category_id = ? AND stream_tag NOT IN ($placeholders)";
        $stmt_del = $pdo->prepare($sql_del);
        $stmt_del->execute(array_merge([$category_id], $tags_actuales));
    } else {
        // Opción B: Si el JSON viene vacío, borramos todos los canales de esa categoría
        $stmt_del = $pdo->prepare("DELETE FROM channels WHERE category_id = ?");
        $stmt_del->execute([$category_id]);
    }

    echo "Sincronización Exitosa. Total eventos en JSON: " . count($tags_actuales);

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}