<?php
session_start();
header("Content-Type: application/json; charset=UTF-8");

// === LOG DE SESIÓN ===
$logfile = '/home/yaetfswo/public_html/panel_api/login/log.txt';
file_put_contents($logfile, "\n[SYSTEM CHECK] --- " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);
file_put_contents($logfile, "PHPSESSID: " . (session_id() ?: 'ninguno') . "\n", FILE_APPEND);
file_put_contents($logfile, "User ID: " . ($_SESSION['user_id'] ?? 'no definido') . "\n", FILE_APPEND);
file_put_contents($logfile, "Vencimiento: " . ($_SESSION['vencimiento'] ?? 'no definido') . "\n", FILE_APPEND);

// === VERIFICACIÓN DE SESIÓN ===
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'No estás autorizado para acceder a esta página.'
    ]);
    exit;
}

try {
    $vencimiento = new DateTime($_SESSION['vencimiento']);
    $ahora = new DateTime();

    if ($ahora > $vencimiento) {
        session_unset();
        session_destroy();
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'message' => 'La sesión ha expirado.',
            'expired' => true
        ]);
        exit;
    }

    echo json_encode([
        'success' => true,
        'user_id' => $_SESSION['user_id'],
        'email' => $_SESSION['email'] ?? null,
        'vencimiento' => $_SESSION['vencimiento']
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al validar la sesión: ' . $e->getMessage()
    ]);
    exit;
}  
