<?php
// generar_email.php - Script para generar emails únicos mediante AJAX

session_start();

// Verificar si el usuario ha iniciado sesión
if (!isset($_SESSION['user_email'])) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'No autorizado']);
    exit();
}

// Función para generar email aleatorio y verificar que no exista en la DB
function generarEmailUnico($conn) {
    $letras = 'abcdefghijklmnopqrstuvwxyz';
    $intentos = 0;
    $maxIntentos = 100; // Límite de intentos para evitar bucles infinitos
    
    do {
        $usuario = '';
        for ($i = 0; $i < 8; $i++) {
            $usuario .= $letras[rand(0, strlen($letras) - 1)];
        }
        
        $email = $usuario . '@yae.tv';
        
        // Verificar si el email ya existe en la base de datos
        $stmt = $conn->prepare("SELECT COUNT(*) FROM users WHERE email = :email");
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        
        $intentos++;
        
        // Si encontramos un email único o alcanzamos el límite de intentos, salimos del bucle
        if ($count == 0 || $intentos >= $maxIntentos) {
            break;
        }
    } while (true);
    
    return $email;
}

try {
    include 'db.php';
    $conn = $pdo;

    // Generar un email único
    $email = generarEmailUnico($conn);

    // Devolver el email en formato JSON
    header('Content-Type: application/json');
    echo json_encode(['email' => $email]);

} catch(PDOException $e) {
    // Error en la conexión o en la generación
    header('Content-Type: application/json');
    echo json_encode(['error' => $e->getMessage()]);
}
?>