
<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();

// Check if user is already logged in
if (isset($_SESSION['user_id'])) {
    header("Location: opciones.php");
    exit();
}

// Conexión centralizada
include 'db.php';
$conn = $mysqli;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    // Validate input
    if (empty($email) || empty($password)) {
        $error = "Por favor, completa todos los campos.";
    } else {
        $sql = "SELECT * FROM resellers WHERE email = ?";
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            error_log("Prepare failed: " . $conn->error);
            $error = "Error interno del servidor.";
        } else {
            $stmt->bind_param("s", $email);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows == 1) {
                $row = $result->fetch_assoc();
                // Plain-text password comparison (temporary, for compatibility)
                if ($password === $row['password']) {
                    $_SESSION['user_id'] = $row['id'];
                    $_SESSION['user_name'] = $row['nombre'];
                    $_SESSION['user_email'] = $row['email'];
                    $_SESSION['user_credits'] = $row['creditos'];
                    error_log("Login successful for email: $email");
                    header("Location: opciones.php");
                    exit();
                } else {
                    $error = "Contraseña inválida";
                    error_log("Invalid password for email: $email");
                }
            } else {
                $error = "Usuario no encontrado";
                error_log("User not found for email: $email");
            }
            $stmt->close();
        }
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> PANEL YAETV - Iniciar Sesión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #16a085;
            --accent-color: #3498db;
            --danger-color: #e74c3c;
            --success-color: #27ae60;
            --light-bg: #f8f9fa;
            --dark-text: #2c3e50;
            --light-text: #ecf0f1;
            --card-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --hover-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
        }

        body {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .login-container {
            max-width: 900px;
            margin: auto;
            padding: 1rem;
        }

        .card {
            border: none;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: var(--card-shadow);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: var(--hover-shadow);
        }

        .left-panel {
            background: linear-gradient(to bottom, var(--secondary-color), var(--primary-color));
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: var(--light-text);
            padding: 2rem;
        }

        .logo {
            font-size: 3rem;
            margin-bottom: 1rem;
        }

        .left-panel h1 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .left-panel p {
            font-size: 1.1rem;
            opacity: 0.9;
        }

        .right-panel {
            padding: 3rem;
            background: white;
        }

        .form-label {
            font-weight: 500;
            color: var(--dark-text);
        }

        .form-control {
            border-radius: 8px;
            border: 1px solid #ced4da;
            padding: 0.75rem;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--secondary-color);
            box-shadow: 0 0 0 0.25rem rgba(22, 160, 133, 0.25);
        }

        .btn-success {
            background-color: var(--success-color);
            border-color: var(--success-color);
            border-radius: 8px;
            padding: 0.75rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-success:hover {
            background-color: #219653; /* Darker shade of success color */
            border-color: #219653;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .alert {
            border-radius: 8px;
            font-size: 0.9rem;
        }

        .form-floating > label {
            padding: 0.75rem;
        }

        @media (max-width: 767.98px) {
            .left-panel {
                padding: 1.5rem;
            }

            .right-panel {
                padding: 2rem;
            }

            .card {
                margin: 1rem;
            }

            .left-panel h1 {
                font-size: 1.5rem;
            }

            .logo {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container login-container">
        <div class="card">
            <div class="row g-0">
                <div class="col-md-5 left-panel">
                    <i class="fa-solid fa-tv logo"></i>
                    <h1>PANEL YAETV</h1>
                    <p>Inicia sesión para gestionar tus revendedores</p>
                </div>
                <div class="col-md-7 right-panel">
                    <?php if (isset($error)) { ?>
                        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                    <?php } ?>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                        <div class="mb-3 form-floating">
                            <input type="email" id="email" name="email" required class="form-control" placeholder="tu@email.com">
                            <label for="email">Email</label>
                        </div>
                        <div class="mb-3 form-floating">
                            <input type="password" name="password" id="password" class="form-control" placeholder="Tu contraseña">
                            <label for="password">Contraseña</label>
                        </div>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-success btn-lg">Entrar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
