<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
date_default_timezone_set('America/Argentina/Buenos_Aires');

if (!isset($_SESSION['user_email'])) {
    header("Location: index.php");
    exit();
}

include 'db.php';

try {
    $conn = $pdo;
    $conn->exec("SET time_zone = '-03:00'");

    $search = isset($_GET['search']) ? $_GET['search'] : '';
    $stmt = $conn->prepare("SELECT * FROM users WHERE idv = :idv AND vencimiento > NOW() AND vencimiento <= DATE_ADD(NOW(), INTERVAL 7 DAY) AND email LIKE :search");
    $stmt->bindParam(':idv', $_SESSION['user_email']);
    $stmt->bindValue(':search', "%$search%");
    $stmt->execute();
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $total_por_vencer = count($users);

    $stmt = $conn->prepare("SELECT creditos FROM resellers WHERE email = :email");
    $stmt->bindParam(':email', $_SESSION['user_email']);
    $stmt->execute();
    $reseller = $stmt->fetch(PDO::FETCH_ASSOC);

} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    exit();
}

$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Usuarios por Vencer</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles/users.css">
</head>
<body>
<div class="container mt-4">
    <h2 class="text-center mb-4">Usuarios por Vencer (7 días) (<?php echo $total_por_vencer; ?>)</h2>

    <form method="get" class="mb-4" style="max-width: 400px; margin: 0 auto;">
        <div class="d-flex">
            <input type="text" class="form-control" name="search" placeholder="Buscar por email" value="<?php echo htmlspecialchars($search); ?>" style="margin-right: 10px;">
            <button type="submit" class="btn btn-custom-light p-2">Buscar</button>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-striped table-hover table-custom text-center">
            <thead>
                <tr>
                    <th>Email</th>
                    <th>Teléfono</th>
                    <th>Contraseña</th>
                    <th>Vencimiento</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                    <td><?php echo htmlspecialchars($user['phone']); ?></td>
                    <td><?php echo htmlspecialchars($user['password']); ?></td>
                    <td><?php echo htmlspecialchars($user['vencimiento']); ?></td>
                    <td>
                        <button class="btn btn-custom-light btn-sm edit-user" data-bs-toggle="modal" data-bs-target="#editModal" data-user-id="<?php echo $user['id']; ?>">Editar</button>
                        <button class="btn btn-custom-dark btn-sm renew-user" data-bs-toggle="modal" data-bs-target="#renewModal" data-user-id="<?php echo $user['id']; ?>">Renovar</button>
                        <button class="btn btn-danger btn-sm delete-user" data-bs-toggle="modal" data-bs-target="#deleteModal" data-user-id="<?php echo $user['id']; ?>" data-user-email="<?php echo htmlspecialchars($user['email']); ?>">Eliminar</button>
                        <button class="btn btn-warning btn-sm delete-devices" data-bs-toggle="modal" data-bs-target="#deleteDevicesModal" data-user-id="<?php echo $user['id']; ?>" data-user-email="<?php echo htmlspecialchars($user['email']); ?>">Eliminar Dispositivos</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="mt-3 text-center">
            <a href="opciones.php" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left"></i> Volver al Panel de Control
            </a>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

