<?php
session_start();

if (!isset($_SESSION['user_email'])) {
    header("Location: index.php");
    exit();
}

// Conexión centralizada
include 'db.php';

$message = ''; // Variable para mensajes

// Función para enviar notificaciones a Telegram
function sendTelegramNotification($message) {
    $token = '6931828140:AAH_ihE5b9k8Nox7f1yj_g733mTSMSk_l2M'; // Token de tu bot
    $chat_id = '994570624'; // Tu chat ID
    $url = "https://api.telegram.org/bot$token/sendMessage?chat_id=$chat_id&text=" . urlencode($message);
    file_get_contents($url);
}

try {
    // $pdo ya está disponible desde db.php

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Obtener los datos del formulario
        $nombre = htmlspecialchars($_POST['nombre'], ENT_QUOTES, 'UTF-8');
        $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
        $password = htmlspecialchars($_POST['password'], ENT_QUOTES, 'UTF-8');
        $telefono = htmlspecialchars($_POST['telefono'], ENT_QUOTES, 'UTF-8');
        $creditos = intval($_POST['creditos']);
        $user_email = $_SESSION['user_email'];

        // Comprobar si el usuario está logueado
        if (!isset($user_email)) {
            $message = "Error: No estás logueado.";
        } else {
            // Iniciar transacción
            $pdo->beginTransaction();

            // Verificar el valor de super y créditos del usuario logueado
            $stmt = $pdo->prepare("SELECT creditos, super FROM resellers WHERE email = :user_email");
            $stmt->execute(['user_email' => $user_email]);
            $result = $stmt->fetch();

            if ($result) {
                // Verificar el valor de super
                if ($result['super'] == 0) {
                    $message = "Error: No eres un SUPER RESELLER. No puedes agregar nuevos resellers.";
                } elseif ($result['creditos'] >= $creditos) {
                    // Obtener el valor de super del checkbox
                    $super = isset($_POST['panel_reseller']) ? 1 : 0;

                    // Restar créditos del usuario logueado
                    $stmt = $pdo->prepare("UPDATE resellers SET creditos = creditos - :creditos WHERE email = :user_email");
                    $stmt->execute([
                        'creditos' => $creditos,
                        'user_email' => $user_email,
                    ]);

                    // Agregar nuevo reseller
                    $stmt = $pdo->prepare("INSERT INTO resellers (nombre, email, password, telefono, creditos, idv, super) 
                                           VALUES (:nombre, :email, :password, :telefono, :creditos, :idv, :super)");
                    $stmt->execute([
                        'nombre' => $nombre,
                        'email' => $email,
                        'password' => $password, // Guardar contraseña en texto plano
                        'telefono' => $telefono,
                        'creditos' => $creditos,
                        'idv' => $user_email, // Añadir el correo del usuario logueado
                        'super' => $super, // Guardar el valor de super
                    ]);

                    // Confirmar transacción
                    $pdo->commit();
                    $message = "Nuevo reseller agregado con éxito.";

                    // Enviar notificación a Telegram
                    $creditos_restantes = $result['creditos'] - $creditos;
                    $telegram_message = "Nuevo reseller agregado:\n".
                                        "Email del usuario que agregó: $user_email\n".
                                        "Email del nuevo reseller: $email\n".
                                        "Créditos asignados: $creditos\n".
                                        "Créditos restantes: $creditos_restantes";
                    sendTelegramNotification($telegram_message);

                    // Agregar el script para copiar email y password
                    echo "<script>setTimeout(function() { copiarDatos('$email', '$password'); }, 100);</script>";
                } else {
                    $message = "Error: No tienes suficientes créditos para agregar este reseller.";
                    $pdo->rollBack(); // Revertir transacción si no hay suficientes créditos
                }
            } else {
                $message = "Error: Usuario no encontrado.";
                $pdo->rollBack(); // Revertir transacción si el usuario no existe
            }
        }
    } else {
        // Comprobar si el usuario está logueado y obtener su información
        $user_email = $_SESSION['user_email'];
        if (isset($user_email)) {
            $stmt = $pdo->prepare("SELECT super FROM resellers WHERE email = :user_email");
            $stmt->execute(['user_email' => $user_email]);
            $result = $stmt->fetch();

            if ($result && $result['super'] == 0) {
                $message = "Error: No eres un SUPER RESELLER. No puedes agregar nuevos resellers.";
            }
        }
    }
} catch (\PDOException $e) {
    $pdo->rollBack();
    $message = "Error de base de datos: " . $e->getMessage();
} catch (\Exception $e) {
    $message = "Error general: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar Reseller</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles/add_reseller.css">
    <script>
        function confirmCheckBox() {
            const checkBox = document.getElementById("panel_reseller");
            if (checkBox.checked) {
                const confirmed = confirm("¿Estás seguro de que deseas agregar como super reseller? El usuario podra revender paneles como usted");
                if (!confirmed) {
                    checkBox.checked = false; // Desmarcar el checkbox si el usuario cancela
                }
            }
        }
        
        async function copiarAlPortapapeles(texto) {
            try {
                await navigator.clipboard.writeText(texto);
                alert("Texto copiado al portapapeles: " + texto);
            } catch (err) {
                console.error('Error al copiar: ', err);
            }
        }
        
        function copiarDatos(email, password) {
            copiarAlPortapapeles("Email: " + email + "\nContraseña: " + password);
        }
    </script>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10 col-sm-12">
                <div class="form-container">
                    <h2 class="form-title">Agregar Nuevo Reseller</h2>
                    <?php if ($message): ?>
                        <div class="alert alert-warning"><?php echo $message; ?></div>
                    <?php endif; ?>
                    <?php if (isset($result) && $result['super'] == 1): ?>
                        <form method="post" action="add_reseller.php">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="nombre" class="form-label">Nombre:</label>
                                    <input type="text" class="form-control" id="nombre" name="nombre" required placeholder="Nombre del reseller">
                                </div>
                                <div class="col-md-6">
                                    <label for="email" class="form-label">Email:</label>
                                    <input type="email" class="form-control" id="email" name="email" required placeholder="ejemplo@dominio.com">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="password" class="form-label">Contraseña:</label>
                                    <input type="password" class="form-control" id="password" name="password" required placeholder="Contraseña segura">
                                </div>
                                <div class="col-md-3">
                                    <label for="telefono" class="form-label">Teléfono:</label>
                                    <input type="text" class="form-control" id="telefono" name="telefono" placeholder="123456789">
                                </div>
                                <div class="col-md-3">
                                    <label for="creditos" class="form-label">Créditos:</label>
                                    <input type="number" class="form-control" id="creditos" name="creditos" value="0" required>
                                </div>
                            </div>
                            <div class="mb-3">
                                <input type="checkbox" id="panel_reseller" name="panel_reseller" value="1" onchange="confirmCheckBox()">
                                <label for="panel_reseller" class="form-label">SELECCIONE PARA CREAR SUPER RESELLER</label>
                            </div>
                            <div class="mb-3 d-flex justify-content-center">
                                <button type="submit" class="btn btn-success btn-lg">Agregar Reseller</button>
                            </div>
                        </form>
                    <?php endif; ?>
                    <div class="mt-3 d-flex justify-content-center">
                        <a href="opciones.php" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left"></i> Volver al Panel de Control
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
