<?php
session_start();

// Verificar si el usuario ha iniciado sesión
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Conexión centralizada
include 'db.php';

try {
    // $pdo ya está disponible desde db.php

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Obtener los datos del formulario
        $id = intval($_POST['id']);
        $nombre = htmlspecialchars($_POST['nombre'], ENT_QUOTES, 'UTF-8');
        $telefono = htmlspecialchars($_POST['telefono'], ENT_QUOTES, 'UTF-8');
        $creditos_a_agregar = intval($_POST['creditos']);
        $new_email = htmlspecialchars($_POST['email'], ENT_QUOTES, 'UTF-8');
        $new_password = htmlspecialchars($_POST['password'], ENT_QUOTES, 'UTF-8');
        $user_email = $_SESSION['user_email'];

        // Iniciar transacción
        $pdo->beginTransaction();

        // Verificar créditos del usuario logueado
        $stmt = $pdo->prepare("SELECT creditos FROM resellers WHERE email = :user_email");
        $stmt->execute(['user_email' => $user_email]);
        $result = $stmt->fetch();

        if ($result && $result['creditos'] >= $creditos_a_agregar) {
            // Restar créditos del usuario logueado
            $stmt = $pdo->prepare("UPDATE resellers SET creditos = creditos - :creditos WHERE email = :user_email");
            $stmt->execute([
                'creditos' => $creditos_a_agregar,
                'user_email' => $user_email,
            ]);

            // Actualizar el reseller
            $stmt = $pdo->prepare("UPDATE resellers SET nombre = :nombre, telefono = :telefono, email = :email, password = :password, creditos = creditos + :creditos WHERE id = :id");
            $stmt->execute([
                'nombre' => $nombre,
                'telefono' => $telefono,
                'email' => $new_email,
                'password' => $new_password,
                'creditos' => $creditos_a_agregar,
                'id' => $id,
            ]);

            // Confirmar transacción
            $pdo->commit();

            // Establecer mensaje de éxito en la sesión
            $_SESSION['message'] = "Revendedor actualizado con éxito.";

            // Redirigir a la misma página para evitar el reenvío del formulario
            header("Location: editar_reseller.php?id=$id");
            exit();
        } else {
            echo "Error: No tienes suficientes créditos para agregar al revendedor.";
            $pdo->rollBack(); // Revertir transacción si no hay suficientes créditos
        }
    } else {
        // Inicializar la variable $reseller
        $reseller = null;

        // Obtener el id del reseller a editar
        if (isset($_GET['id'])) {
            $id = intval($_GET['id']);

            // Obtener los detalles del reseller
            $stmt = $pdo->prepare("SELECT * FROM resellers WHERE id = :id");
            $stmt->execute(['id' => $id]);
            $reseller = $stmt->fetch();
        }
    }
} catch (\PDOException $e) {
    $pdo->rollBack();
    echo "Error de base de datos: " . $e->getMessage();
} catch (\Exception $e) {
    echo "Error general: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Reseller</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles/add_reseller.css">
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10 col-sm-12">
                <div class="form-container">
                    <h2 class="form-title">Editar Reseller</h2>
                    <?php
                    if (isset($_SESSION['message'])) {
                        echo "<p class='alert alert-info'>" . $_SESSION['message'] . "</p>";
                        unset($_SESSION['message']); // Eliminar mensaje de la sesión
                    }
                    ?>
                    <?php if ($reseller): ?>
                        <form method="post" action="editar_reseller.php">
                            <input type="hidden" name="id" value="<?php echo $reseller['id']; ?>">
                            <div class="mb-3">
                                <label for="nombre" class="form-label">Nombre:</label>
                                <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo htmlspecialchars($reseller['nombre'], ENT_QUOTES, 'UTF-8'); ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="telefono" class="form-label">Teléfono:</label>
                                <input type="text" class="form-control" id="telefono" name="telefono" value="<?php echo htmlspecialchars($reseller['telefono'], ENT_QUOTES, 'UTF-8'); ?>">
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email:</label>
                                <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($reseller['email'], ENT_QUOTES, 'UTF-8'); ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Contraseña:</label>
                                <input type="text" class="form-control" id="password" name="password" value="<?php echo htmlspecialchars($reseller['password'], ENT_QUOTES, 'UTF-8'); ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="creditos" class="form-label">Agregar Créditos:</label>
                                <input type="number" class="form-control" id="creditos" name="creditos" value="0" required>
                            </div>
                            <div class="mb-3 d-flex justify-content-center">
                                <input type="submit" class="btn btn-success btn-lg" value="Actualizar Reseller">
                            </div>
                        </form>
                    <?php else: ?>
                        <p class="alert alert-danger">Error: Revendedor no encontrado.</p>
                    <?php endif; ?>
                    <div class="mt-3 d-flex justify-content-center">
                        <a href="listar_resellers.php" class="btn btn-outline-secondary">Volver a la Lista de Revendedores</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
